const boolean inputMode = HIGH;// high for buttons LOW for piezo

const int numPorts=4;
int led[numPorts]={5,6,7,8};
int ins[numPorts]={A0,A1,A2,A3};
int goButton=A4;
int rotarySwitch[3]={2,3,9};

int theDelay=1;

unsigned long time1;
unsigned long time2;
float interval1;

void setup() 
{
  pinMode(goButton,INPUT);
  digitalWrite(goButton,HIGH);
  
  for (int i=0; i<numPorts; i++)
  {  
    pinMode(led[i], OUTPUT);
    pinMode(ins[i],INPUT); 
    //if (inputMode==HIGH) digitalWrite(ins[i],HIGH); // activate internal pullup;
  }
  
  for (int i=0; i<3; i++)
  {
    pinMode(rotarySwitch[i],INPUT);
    digitalWrite(rotarySwitch[i],HIGH);//internal pullup
  }
  
  
  Serial.begin(9600);
  Serial.write(0x0C); delay(5);

  doPost();

  Serial.write(0x0C); delay(5);
  Serial.write(0xFA); //define custom character 2
  //Now send the eight data bytes 
  Serial.write(B00000100); 
  Serial.write(B00000100); 
  Serial.write(B00011111); 
  Serial.write(B00000100); 
  Serial.write(B00000100); 
  Serial.write(B00000100); 
  Serial.write(B00000000); 
  Serial.write(B00011111); 
  //Serial1.write(0x02); //Display the new custom character 2 
  Serial.write(0x11);
  Serial.write(0x0C); delay(5);
  //               0000000000111111     
  //               0123456789012345
  Serial.println("Select a mode   ");
  Serial.println("then press GO   ");
}

void loop() 
{
  //Serial1.write(0x12);
  //delay(1000);
  Serial.write(0x0C); delay(5);
  //              0000000000111111     
  //              0123456789012345
  Serial.println("Select a mode   ");
  Serial.println("press RUN       ");
  
  while ((PINC & B00010000));

  
  //doRapidFire();
  
  if (digitalRead(rotarySwitch[0])==LOW) doQuickDraw();
  else if (digitalRead(rotarySwitch[1])==LOW) doTimedMode();
    else if (digitalRead(rotarySwitch[2])==LOW) doRapidFire();
  
  //doQuickDraw();
  //doTimedMode();
  //doRapidFire();
}

void doTimedMode()
{
  randomSeed(millis());

  int currentPort=random(4);
  int newPort=random(4);
  int maxRounds=32;
  int hitCounter=0;
  time1=millis();
  interval1=0;

  Serial.write(0x0C); delay(5);
  //              0000000000111111     
  Serial.println("Timed mode");
  delay(3000);
  Serial.write(0x0C); delay(5);
  Serial.write(0xDF); // C note
  Serial.println("GO");  
  while (interval1 < 10000) // 10 seconds
  {
    //time1=millis();
    digitalWrite(led[currentPort],HIGH);
    switch (currentPort)
    {
      case 0:
        while (!(PINC & B00000001));
        break;
      case 1:
        while (!(PINC & B00000010));
        break;
      case 2:
        while (!(PINC & B00000100));
        break;
      case 3:
        while (!(PINC & B00001000));
        break;
    }
    hitCounter++;
    //delay(1000);
    time2=millis(); 
    interval1=(time2-time1);
    digitalWrite(led[currentPort],LOW);
    Serial.write(0x0C); delay(5);
    //             0000000000111111     
    Serial.print("Hits: ");
    Serial.println(hitCounter,DEC);
    newPort=random(4);
    while (newPort==currentPort) newPort=random(4);
    currentPort=newPort;
  }
    Serial.write(0x0C); delay(5);
    Serial.print(hitCounter,DEC);
    Serial.println(" Hits");
    Serial.write(0x0D);
    Serial.println("in 10Secs");
  delay(5000);
}
void doRapidFire()
{
  randomSeed(millis());

  int currentPort=random(4);
  int newPort=random(4);
  int maxRounds=32;
  time1=millis();

  Serial.write(0x0C); delay(5);
  //              0000000000111111     
  Serial.println("Rapid Fire mode");
  
  delay(2000);
  
  Serial.write(0xDF); // C note

  
  for (int i=0; i<maxRounds; i++)
  {
    Serial.write(0x0C); delay(10);
    //              0000000000111111     
    Serial.println("Rapid Fire mode");
    Serial.print("Round ");
    Serial.print(i+1,DEC);
    Serial.print(" of ");
    Serial.print(maxRounds,DEC);
    Serial.println("");
    digitalWrite(led[currentPort],HIGH);
    switch (currentPort)
    {
      case 0:
        while (!(PINC & B00000001));
        break;
      case 1:
        while (!(PINC & B00000010));
        break;
      case 2:
        while (!(PINC & B00000100));
        break;
      case 3:
        while (!(PINC & B00001000));
        break;
    }
    //delay(1000);
    //interval1=interval1+0.00001;
    digitalWrite(led[currentPort],LOW);
    newPort=random(4);
    while (newPort==currentPort) newPort=random(4);
    
    //newPort=3;
    
    currentPort=newPort;
  }

    time2=millis(); 
    interval1=(time2-time1);
    interval1=interval1/1000; 
    Serial.write(0x0C); delay(5);
    Serial.println("Rapid Time:"); Serial.write(0x0D);
    Serial.print(interval1,4);
    Serial.println(" secs");

  delay(5000);
}


void doQuickDraw()
{
  randomSeed(millis());

  int firstTime=true;

  int currentPort=random(4);
  int maxRounds=8;

  Serial.write(0x0C); delay(5);
  Serial.println("Quickdraw mode  ");
  delay(2000);
  
  for (int i=0; i<maxRounds; i++)
  {
    Serial.write(0x0C); delay(5);
    Serial.println("Quickdraw mode  ");
    Serial.print("Round ");
    Serial.print(i+1,DEC);
    Serial.print(" of ");
    Serial.print(maxRounds,DEC);
    Serial.println("");
    delay(random(3000)+1000);
    if (firstTime==true) { Serial.write(0xDF); firstTime=false; }// C note

    time1=millis();
    digitalWrite(led[currentPort],HIGH);
    switch (currentPort)
    {
      case 0:
        while (!(PINC & B00000001));
        break;
      case 1:
        while (!(PINC & B00000010));
        break;
      case 2:
        while (!(PINC & B00000100));
        break;
      case 3:
        while (!(PINC & B00001000));
        break;
    }
    //delay(1000);
    time2=millis(); 
    interval1=(time2-time1);
    interval1=interval1/1000; 
    digitalWrite(led[currentPort],LOW);
    Serial.write(0x0C); delay(5);
    Serial.println("Quickdraw Time: ");
    Serial.print(interval1,3);
    Serial.println(" seconds");
    delay(2000);
    currentPort=random(4);
  }
  delay(5000);
}

void doPost()
{
  Serial.write(0xD2); // 1/16 note
  Serial.write(0xE3);//E
  //delay(100);
  Serial.write(0xDC);//A
  //delay(100);
  Serial.write(0xDE);//B
  for (int lop=0; lop<20; lop++)
  {
    theDelay+=10;
    if (theDelay>500) theDelay=1;
  
    for (int i=0; i<numPorts; i++)
    {
      //if (digitalRead(ins[i])==HIGH)
      {
        digitalWrite(led[i], HIGH);   // turn the LED on (HIGH is the voltage level)
      }
    }
    delay(theDelay);               // wait for a second
    for (int i=0; i<numPorts; i++)
    {
      digitalWrite(led[i], LOW);    // turn the LED off by making the voltage LOW
    }
    delay(theDelay);               // wait for a second
  }
}
